package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateWebAclRequest(
    webACLId: ResourceId,
    changeToken: ChangeToken,
    updates: Option[Iterable[zio.aws.waf.model.WebACLUpdate]] = None,
    defaultAction: Option[zio.aws.waf.model.WafAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateWebAclRequest = {
    import UpdateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateWebAclRequest
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .optionallyWith(
        updates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updates)
      .optionallyWith(defaultAction.map(value => value.buildAwsValue()))(
        _.defaultAction
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateWebAclRequest.ReadOnly =
    zio.aws.waf.model.UpdateWebAclRequest.wrap(buildAwsValue())
}
object UpdateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateWebAclRequest =
      zio.aws.waf.model.UpdateWebAclRequest(
        webACLId,
        changeToken,
        updates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultAction.map(value => value.asEditable)
      )
    def webACLId: ResourceId
    def changeToken: ChangeToken
    def updates: Option[List[zio.aws.waf.model.WebACLUpdate.ReadOnly]]
    def defaultAction: Option[zio.aws.waf.model.WafAction.ReadOnly]
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates
        : ZIO[Any, AwsError, List[zio.aws.waf.model.WebACLUpdate.ReadOnly]] =
      AwsError.unwrapOptionField("updates", updates)
    def getDefaultAction
        : ZIO[Any, AwsError, zio.aws.waf.model.WafAction.ReadOnly] =
      AwsError.unwrapOptionField("defaultAction", defaultAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateWebAclRequest
  ) extends zio.aws.waf.model.UpdateWebAclRequest.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.webACLId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates
        : Option[List[zio.aws.waf.model.WebACLUpdate.ReadOnly]] = scala
      .Option(impl.updates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.waf.model.WebACLUpdate.wrap(item)
        }.toList
      )
    override val defaultAction: Option[zio.aws.waf.model.WafAction.ReadOnly] =
      scala
        .Option(impl.defaultAction())
        .map(value => zio.aws.waf.model.WafAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateWebAclRequest
  ): zio.aws.waf.model.UpdateWebAclRequest.ReadOnly = new Wrapper(impl)
}
