package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class UpdateWebAclResponse(changeToken: Option[ChangeToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateWebAclResponse = {
    import UpdateWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateWebAclResponse.ReadOnly =
    zio.aws.waf.model.UpdateWebAclResponse.wrap(buildAwsValue())
}
object UpdateWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateWebAclResponse =
      zio.aws.waf.model.UpdateWebAclResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
  ) extends zio.aws.waf.model.UpdateWebAclResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
  ): zio.aws.waf.model.UpdateWebAclResponse.ReadOnly = new Wrapper(impl)
}
