package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.waf.model.primitives.{
  ResourceArn,
  MetricName,
  ResourceName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class WebACL(
    webACLId: ResourceId,
    name: Option[ResourceName] = None,
    metricName: Option[MetricName] = None,
    defaultAction: zio.aws.waf.model.WafAction,
    rules: Iterable[zio.aws.waf.model.ActivatedRule],
    webACLArn: Option[ResourceArn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.WebACL = {
    import WebACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.WebACL
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .defaultAction(defaultAction.buildAwsValue())
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        webACLArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.webACLArn)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.WebACL.ReadOnly =
    zio.aws.waf.model.WebACL.wrap(buildAwsValue())
}
object WebACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.WebACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.WebACL = zio.aws.waf.model.WebACL(
      webACLId,
      name.map(value => value),
      metricName.map(value => value),
      defaultAction.asEditable,
      rules.map { item =>
        item.asEditable
      },
      webACLArn.map(value => value)
    )
    def webACLId: ResourceId
    def name: Option[ResourceName]
    def metricName: Option[MetricName]
    def defaultAction: zio.aws.waf.model.WafAction.ReadOnly
    def rules: List[zio.aws.waf.model.ActivatedRule.ReadOnly]
    def webACLArn: Option[ResourceArn]
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.waf.model.WafAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.waf.model.ActivatedRule.ReadOnly]] =
      ZIO.succeed(rules)
    def getWebACLArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("webACLArn", webACLArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.WebACL
  ) extends zio.aws.waf.model.WebACL.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.webACLId())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.waf.model.primitives.MetricName(value))
    override val defaultAction: zio.aws.waf.model.WafAction.ReadOnly =
      zio.aws.waf.model.WafAction.wrap(impl.defaultAction())
    override val rules: List[zio.aws.waf.model.ActivatedRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.waf.model.ActivatedRule.wrap(item)
      }
      .toList
    override val webACLArn: Option[ResourceArn] = scala
      .Option(impl.webACLArn())
      .map(value => zio.aws.waf.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.WebACL
  ): zio.aws.waf.model.WebACL.ReadOnly = new Wrapper(impl)
}
