package zio.aws.waf
import zio.aws.waf.model.primitives.ResourceId.Type
import zio.aws.waf.model.primitives.{
  TagKey,
  RegexPatternString,
  ManagedKey,
  ResourceArn
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Action extends Subtype[String]
    type Action = zio.aws.waf.model.primitives.Action.Type
    object ByteMatchTargetString extends Subtype[Chunk[Byte]]
    type ByteMatchTargetString =
      zio.aws.waf.model.primitives.ByteMatchTargetString.Type
    object ChangeToken extends Subtype[String]
    type ChangeToken = zio.aws.waf.model.primitives.ChangeToken.Type
    object Country extends Subtype[String]
    type Country = zio.aws.waf.model.primitives.Country.Type
    object GetSampledRequestsMaxItems extends Subtype[Long]
    type GetSampledRequestsMaxItems =
      zio.aws.waf.model.primitives.GetSampledRequestsMaxItems.Type
    object HTTPMethod extends Subtype[String]
    type HTTPMethod = zio.aws.waf.model.primitives.HTTPMethod.Type
    object HTTPVersion extends Subtype[String]
    type HTTPVersion = zio.aws.waf.model.primitives.HTTPVersion.Type
    object HeaderName extends Subtype[String]
    type HeaderName = zio.aws.waf.model.primitives.HeaderName.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue = zio.aws.waf.model.primitives.HeaderValue.Type
    object IPSetDescriptorValue extends Subtype[String]
    type IPSetDescriptorValue =
      zio.aws.waf.model.primitives.IPSetDescriptorValue.Type
    object IPString extends Subtype[String]
    type IPString = zio.aws.waf.model.primitives.IPString.Type
    object IgnoreUnsupportedType extends Subtype[Boolean]
    type IgnoreUnsupportedType =
      zio.aws.waf.model.primitives.IgnoreUnsupportedType.Type
    object ManagedKey extends Subtype[String]
    type ManagedKey = zio.aws.waf.model.primitives.ManagedKey.Type
    object MatchFieldData extends Subtype[String]
    type MatchFieldData = zio.aws.waf.model.primitives.MatchFieldData.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.waf.model.primitives.MetricName.Type
    object Negated extends Subtype[Boolean]
    type Negated = zio.aws.waf.model.primitives.Negated.Type
    object NextMarker extends Subtype[String]
    type NextMarker = zio.aws.waf.model.primitives.NextMarker.Type
    object PaginationLimit extends Subtype[Int]
    type PaginationLimit = zio.aws.waf.model.primitives.PaginationLimit.Type
    object PolicyString extends Subtype[String]
    type PolicyString = zio.aws.waf.model.primitives.PolicyString.Type
    object PopulationSize extends Subtype[Long]
    type PopulationSize = zio.aws.waf.model.primitives.PopulationSize.Type
    object RateLimit extends Subtype[Long]
    type RateLimit = zio.aws.waf.model.primitives.RateLimit.Type
    object RegexPatternString extends Subtype[String]
    type RegexPatternString =
      zio.aws.waf.model.primitives.RegexPatternString.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.waf.model.primitives.ResourceArn.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.waf.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.waf.model.primitives.ResourceName.Type
    object RulePriority extends Subtype[Int]
    type RulePriority = zio.aws.waf.model.primitives.RulePriority.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.waf.model.primitives.S3BucketName.Type
    object S3ObjectUrl extends Subtype[String]
    type S3ObjectUrl = zio.aws.waf.model.primitives.S3ObjectUrl.Type
    object SampleWeight extends Subtype[Long]
    type SampleWeight = zio.aws.waf.model.primitives.SampleWeight.Type
    object Size extends Subtype[Long]
    type Size = zio.aws.waf.model.primitives.Size.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.waf.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.waf.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.waf.model.primitives.Timestamp.Type
    object URIString extends Subtype[String]
    type URIString = zio.aws.waf.model.primitives.URIString.Type
  }
  type ActivatedRules = List[zio.aws.waf.model.ActivatedRule]
  type ByteMatchSetSummaries = List[zio.aws.waf.model.ByteMatchSetSummary]
  type ByteMatchSetUpdates = List[zio.aws.waf.model.ByteMatchSetUpdate]
  type ByteMatchTuples = List[zio.aws.waf.model.ByteMatchTuple]
  type ExcludedRules = List[zio.aws.waf.model.ExcludedRule]
  type GeoMatchConstraints = List[zio.aws.waf.model.GeoMatchConstraint]
  type GeoMatchSetSummaries = List[zio.aws.waf.model.GeoMatchSetSummary]
  type GeoMatchSetUpdates = List[zio.aws.waf.model.GeoMatchSetUpdate]
  type HTTPHeaders = List[zio.aws.waf.model.HTTPHeader]
  type IPSetDescriptors = List[zio.aws.waf.model.IPSetDescriptor]
  type IPSetSummaries = List[zio.aws.waf.model.IPSetSummary]
  type IPSetUpdates = List[zio.aws.waf.model.IPSetUpdate]
  type LogDestinationConfigs = List[ResourceArn]
  type LoggingConfigurations = List[zio.aws.waf.model.LoggingConfiguration]
  type ManagedKeys = List[ManagedKey]
  type Predicates = List[zio.aws.waf.model.Predicate]
  type RedactedFields = List[zio.aws.waf.model.FieldToMatch]
  type RegexMatchSetSummaries = List[zio.aws.waf.model.RegexMatchSetSummary]
  type RegexMatchSetUpdates = List[zio.aws.waf.model.RegexMatchSetUpdate]
  type RegexMatchTuples = List[zio.aws.waf.model.RegexMatchTuple]
  type RegexPatternSetSummaries = List[zio.aws.waf.model.RegexPatternSetSummary]
  type RegexPatternSetUpdates = List[zio.aws.waf.model.RegexPatternSetUpdate]
  type RegexPatternStrings = List[RegexPatternString]
  type RuleGroupSummaries = List[zio.aws.waf.model.RuleGroupSummary]
  type RuleGroupUpdates = List[zio.aws.waf.model.RuleGroupUpdate]
  type RuleSummaries = List[zio.aws.waf.model.RuleSummary]
  type RuleUpdates = List[zio.aws.waf.model.RuleUpdate]
  type SampledHTTPRequests = List[zio.aws.waf.model.SampledHTTPRequest]
  type SizeConstraintSetSummaries =
    List[zio.aws.waf.model.SizeConstraintSetSummary]
  type SizeConstraintSetUpdates =
    List[zio.aws.waf.model.SizeConstraintSetUpdate]
  type SizeConstraints = List[zio.aws.waf.model.SizeConstraint]
  type SqlInjectionMatchSetSummaries =
    List[zio.aws.waf.model.SqlInjectionMatchSetSummary]
  type SqlInjectionMatchSetUpdates =
    List[zio.aws.waf.model.SqlInjectionMatchSetUpdate]
  type SqlInjectionMatchTuples = List[zio.aws.waf.model.SqlInjectionMatchTuple]
  type SubscribedRuleGroupSummaries =
    List[zio.aws.waf.model.SubscribedRuleGroupSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.waf.model.Tag]
  type WebACLSummaries = List[zio.aws.waf.model.WebACLSummary]
  type WebACLUpdates = List[zio.aws.waf.model.WebACLUpdate]
  type XssMatchSetSummaries = List[zio.aws.waf.model.XssMatchSetSummary]
  type XssMatchSetUpdates = List[zio.aws.waf.model.XssMatchSetUpdate]
  type XssMatchTuples = List[zio.aws.waf.model.XssMatchTuple]
}
