package zio.aws.waf.model
import scala.jdk.CollectionConverters._
sealed trait ChangeTokenStatus {
  def unwrap: software.amazon.awssdk.services.waf.model.ChangeTokenStatus
}
object ChangeTokenStatus {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.ChangeTokenStatus
  ): zio.aws.waf.model.ChangeTokenStatus = value match {
    case software.amazon.awssdk.services.waf.model.ChangeTokenStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.ChangeTokenStatus.PROVISIONED =>
      val r = PROVISIONED
      r
    case software.amazon.awssdk.services.waf.model.ChangeTokenStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.waf.model.ChangeTokenStatus.INSYNC =>
      val r = INSYNC
      r
  }
  case object unknownToSdkVersion extends zio.aws.waf.model.ChangeTokenStatus {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeTokenStatus =
      software.amazon.awssdk.services.waf.model.ChangeTokenStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONED extends zio.aws.waf.model.ChangeTokenStatus {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeTokenStatus =
      software.amazon.awssdk.services.waf.model.ChangeTokenStatus.PROVISIONED
  }
  case object PENDING extends zio.aws.waf.model.ChangeTokenStatus {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeTokenStatus =
      software.amazon.awssdk.services.waf.model.ChangeTokenStatus.PENDING
  }
  case object INSYNC extends zio.aws.waf.model.ChangeTokenStatus {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeTokenStatus =
      software.amazon.awssdk.services.waf.model.ChangeTokenStatus.INSYNC
  }
}
