package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateGeoMatchSetResponse(
    geoMatchSet: Optional[zio.aws.waf.model.GeoMatchSet] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateGeoMatchSetResponse = {
    import CreateGeoMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateGeoMatchSetResponse
      .builder()
      .optionallyWith(geoMatchSet.map(value => value.buildAwsValue()))(
        _.geoMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateGeoMatchSetResponse.ReadOnly =
    zio.aws.waf.model.CreateGeoMatchSetResponse.wrap(buildAwsValue())
}
object CreateGeoMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateGeoMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateGeoMatchSetResponse =
      zio.aws.waf.model.CreateGeoMatchSetResponse(
        geoMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def geoMatchSet: Optional[zio.aws.waf.model.GeoMatchSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getGeoMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.GeoMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("geoMatchSet", geoMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateGeoMatchSetResponse
  ) extends zio.aws.waf.model.CreateGeoMatchSetResponse.ReadOnly {
    override val geoMatchSet: Optional[zio.aws.waf.model.GeoMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchSet())
        .map(value => zio.aws.waf.model.GeoMatchSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateGeoMatchSetResponse
  ): zio.aws.waf.model.CreateGeoMatchSetResponse.ReadOnly = new Wrapper(impl)
}
