package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateIpSetResponse(
    ipSet: Optional[zio.aws.waf.model.IPSet] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateIpSetResponse = {
    import CreateIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateIpSetResponse
      .builder()
      .optionallyWith(ipSet.map(value => value.buildAwsValue()))(_.ipSet)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateIpSetResponse.ReadOnly =
    zio.aws.waf.model.CreateIpSetResponse.wrap(buildAwsValue())
}
object CreateIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateIpSetResponse =
      zio.aws.waf.model.CreateIpSetResponse(
        ipSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def ipSet: Optional[zio.aws.waf.model.IPSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getIpSet: ZIO[Any, AwsError, zio.aws.waf.model.IPSet.ReadOnly] =
      AwsError.unwrapOptionField("ipSet", ipSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateIpSetResponse
  ) extends zio.aws.waf.model.CreateIpSetResponse.ReadOnly {
    override val ipSet: Optional[zio.aws.waf.model.IPSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSet())
        .map(value => zio.aws.waf.model.IPSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateIpSetResponse
  ): zio.aws.waf.model.CreateIpSetResponse.ReadOnly = new Wrapper(impl)
}
