package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ChangeToken, MetricName, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateRuleRequest(
    name: ResourceName,
    metricName: MetricName,
    changeToken: ChangeToken,
    tags: Optional[Iterable[zio.aws.waf.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRuleRequest = {
    import CreateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRuleRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRuleRequest.ReadOnly =
    zio.aws.waf.model.CreateRuleRequest.wrap(buildAwsValue())
}
object CreateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRuleRequest =
      zio.aws.waf.model.CreateRuleRequest(
        name,
        metricName,
        changeToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def metricName: MetricName
    def changeToken: ChangeToken
    def tags: Optional[List[zio.aws.waf.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.waf.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleRequest
  ) extends zio.aws.waf.model.CreateRuleRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
    override val metricName: MetricName =
      zio.aws.waf.model.primitives.MetricName(impl.metricName())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val tags: Optional[List[zio.aws.waf.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleRequest
  ): zio.aws.waf.model.CreateRuleRequest.ReadOnly = new Wrapper(impl)
}
