package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateRuleResponse(
    rule: Optional[zio.aws.waf.model.Rule] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRuleResponse = {
    import CreateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRuleResponse.ReadOnly =
    zio.aws.waf.model.CreateRuleResponse.wrap(buildAwsValue())
}
object CreateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRuleResponse =
      zio.aws.waf.model.CreateRuleResponse(
        rule.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def rule: Optional[zio.aws.waf.model.Rule.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getRule: ZIO[Any, AwsError, zio.aws.waf.model.Rule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleResponse
  ) extends zio.aws.waf.model.CreateRuleResponse.ReadOnly {
    override val rule: Optional[zio.aws.waf.model.Rule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.waf.model.Rule.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleResponse
  ): zio.aws.waf.model.CreateRuleResponse.ReadOnly = new Wrapper(impl)
}
