package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class DeleteByteMatchSetRequest(
    byteMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteByteMatchSetRequest = {
    import DeleteByteMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteByteMatchSetRequest
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteByteMatchSetRequest.ReadOnly =
    zio.aws.waf.model.DeleteByteMatchSetRequest.wrap(buildAwsValue())
}
object DeleteByteMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteByteMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteByteMatchSetRequest =
      zio.aws.waf.model.DeleteByteMatchSetRequest(byteMatchSetId, changeToken)
    def byteMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteByteMatchSetRequest
  ) extends zio.aws.waf.model.DeleteByteMatchSetRequest.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.byteMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteByteMatchSetRequest
  ): zio.aws.waf.model.DeleteByteMatchSetRequest.ReadOnly = new Wrapper(impl)
}
