package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class DeleteGeoMatchSetRequest(
    geoMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest = {
    import DeleteGeoMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteGeoMatchSetRequest.ReadOnly =
    zio.aws.waf.model.DeleteGeoMatchSetRequest.wrap(buildAwsValue())
}
object DeleteGeoMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteGeoMatchSetRequest =
      zio.aws.waf.model.DeleteGeoMatchSetRequest(geoMatchSetId, changeToken)
    def geoMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
  ) extends zio.aws.waf.model.DeleteGeoMatchSetRequest.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.geoMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
  ): zio.aws.waf.model.DeleteGeoMatchSetRequest.ReadOnly = new Wrapper(impl)
}
