package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class DeletePermissionPolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeletePermissionPolicyRequest = {
    import DeletePermissionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeletePermissionPolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeletePermissionPolicyRequest.ReadOnly =
    zio.aws.waf.model.DeletePermissionPolicyRequest.wrap(buildAwsValue())
}
object DeletePermissionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeletePermissionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeletePermissionPolicyRequest =
      zio.aws.waf.model.DeletePermissionPolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeletePermissionPolicyRequest
  ) extends zio.aws.waf.model.DeletePermissionPolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.waf.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeletePermissionPolicyRequest
  ): zio.aws.waf.model.DeletePermissionPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
