package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class DeleteRateBasedRuleRequest(
    ruleId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleRequest = {
    import DeleteRateBasedRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteRateBasedRuleRequest.ReadOnly =
    zio.aws.waf.model.DeleteRateBasedRuleRequest.wrap(buildAwsValue())
}
object DeleteRateBasedRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteRateBasedRuleRequest =
      zio.aws.waf.model.DeleteRateBasedRuleRequest(ruleId, changeToken)
    def ruleId: ResourceId
    def changeToken: ChangeToken
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleRequest
  ) extends zio.aws.waf.model.DeleteRateBasedRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRateBasedRuleRequest
  ): zio.aws.waf.model.DeleteRateBasedRuleRequest.ReadOnly = new Wrapper(impl)
}
