package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class DeleteXssMatchSetRequest(
    xssMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest = {
    import DeleteXssMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteXssMatchSetRequest.ReadOnly =
    zio.aws.waf.model.DeleteXssMatchSetRequest.wrap(buildAwsValue())
}
object DeleteXssMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteXssMatchSetRequest =
      zio.aws.waf.model.DeleteXssMatchSetRequest(xssMatchSetId, changeToken)
    def xssMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
  ) extends zio.aws.waf.model.DeleteXssMatchSetRequest.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.xssMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
  ): zio.aws.waf.model.DeleteXssMatchSetRequest.ReadOnly = new Wrapper(impl)
}
