package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.MatchFieldData
import scala.jdk.CollectionConverters._
final case class FieldToMatch(
    `type`: zio.aws.waf.model.MatchFieldType,
    data: Optional[MatchFieldData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.FieldToMatch = {
    import FieldToMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.FieldToMatch
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        data.map(value => MatchFieldData.unwrap(value): java.lang.String)
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.FieldToMatch.ReadOnly =
    zio.aws.waf.model.FieldToMatch.wrap(buildAwsValue())
}
object FieldToMatch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.FieldToMatch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.FieldToMatch =
      zio.aws.waf.model.FieldToMatch(`type`, data.map(value => value))
    def `type`: zio.aws.waf.model.MatchFieldType
    def data: Optional[MatchFieldData]
    def getType: ZIO[Any, Nothing, zio.aws.waf.model.MatchFieldType] =
      ZIO.succeed(`type`)
    def getData: ZIO[Any, AwsError, MatchFieldData] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.FieldToMatch
  ) extends zio.aws.waf.model.FieldToMatch.ReadOnly {
    override val `type`: zio.aws.waf.model.MatchFieldType =
      zio.aws.waf.model.MatchFieldType.wrap(impl.`type`())
    override val data: Optional[MatchFieldData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.waf.model.primitives.MatchFieldData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.FieldToMatch
  ): zio.aws.waf.model.FieldToMatch.ReadOnly = new Wrapper(impl)
}
