package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GeoMatchSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    geoMatchConstraint: zio.aws.waf.model.GeoMatchConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate = {
    import GeoMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .geoMatchConstraint(geoMatchConstraint.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GeoMatchSetUpdate.ReadOnly =
    zio.aws.waf.model.GeoMatchSetUpdate.wrap(buildAwsValue())
}
object GeoMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GeoMatchSetUpdate =
      zio.aws.waf.model.GeoMatchSetUpdate(action, geoMatchConstraint.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def geoMatchConstraint: zio.aws.waf.model.GeoMatchConstraint.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getGeoMatchConstraint
        : ZIO[Any, Nothing, zio.aws.waf.model.GeoMatchConstraint.ReadOnly] =
      ZIO.succeed(geoMatchConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
  ) extends zio.aws.waf.model.GeoMatchSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val geoMatchConstraint
        : zio.aws.waf.model.GeoMatchConstraint.ReadOnly =
      zio.aws.waf.model.GeoMatchConstraint.wrap(impl.geoMatchConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
  ): zio.aws.waf.model.GeoMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
