package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetByteMatchSetRequest(byteMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest = {
    import GetByteMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetByteMatchSetRequest.ReadOnly =
    zio.aws.waf.model.GetByteMatchSetRequest.wrap(buildAwsValue())
}
object GetByteMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetByteMatchSetRequest =
      zio.aws.waf.model.GetByteMatchSetRequest(byteMatchSetId)
    def byteMatchSetId: ResourceId
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
  ) extends zio.aws.waf.model.GetByteMatchSetRequest.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.byteMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
  ): zio.aws.waf.model.GetByteMatchSetRequest.ReadOnly = new Wrapper(impl)
}
