package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class GetChangeTokenStatusRequest(changeToken: ChangeToken) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest = {
    import GetChangeTokenStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest
      .builder()
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetChangeTokenStatusRequest.ReadOnly =
    zio.aws.waf.model.GetChangeTokenStatusRequest.wrap(buildAwsValue())
}
object GetChangeTokenStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetChangeTokenStatusRequest =
      zio.aws.waf.model.GetChangeTokenStatusRequest(changeToken)
    def changeToken: ChangeToken
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest
  ) extends zio.aws.waf.model.GetChangeTokenStatusRequest.ReadOnly {
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest
  ): zio.aws.waf.model.GetChangeTokenStatusRequest.ReadOnly = new Wrapper(impl)
}
