package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGeoMatchSetResponse(
    geoMatchSet: Optional[zio.aws.waf.model.GeoMatchSet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse = {
    import GetGeoMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
      .builder()
      .optionallyWith(geoMatchSet.map(value => value.buildAwsValue()))(
        _.geoMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetGeoMatchSetResponse.ReadOnly =
    zio.aws.waf.model.GetGeoMatchSetResponse.wrap(buildAwsValue())
}
object GetGeoMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetGeoMatchSetResponse = zio.aws.waf.model
      .GetGeoMatchSetResponse(geoMatchSet.map(value => value.asEditable))
    def geoMatchSet: Optional[zio.aws.waf.model.GeoMatchSet.ReadOnly]
    def getGeoMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.GeoMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("geoMatchSet", geoMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
  ) extends zio.aws.waf.model.GetGeoMatchSetResponse.ReadOnly {
    override val geoMatchSet: Optional[zio.aws.waf.model.GeoMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchSet())
        .map(value => zio.aws.waf.model.GeoMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetResponse
  ): zio.aws.waf.model.GetGeoMatchSetResponse.ReadOnly = new Wrapper(impl)
}
