package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{NextMarker, ResourceId}
import scala.jdk.CollectionConverters._
final case class GetRateBasedRuleManagedKeysRequest(
    ruleId: ResourceId,
    nextMarker: Optional[NextMarker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysRequest = {
    import GetRateBasedRuleManagedKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.waf.model.GetRateBasedRuleManagedKeysRequest.ReadOnly =
    zio.aws.waf.model.GetRateBasedRuleManagedKeysRequest.wrap(buildAwsValue())
}
object GetRateBasedRuleManagedKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRateBasedRuleManagedKeysRequest =
      zio.aws.waf.model.GetRateBasedRuleManagedKeysRequest(
        ruleId,
        nextMarker.map(value => value)
      )
    def ruleId: ResourceId
    def nextMarker: Optional[NextMarker]
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysRequest
  ) extends zio.aws.waf.model.GetRateBasedRuleManagedKeysRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleManagedKeysRequest
  ): zio.aws.waf.model.GetRateBasedRuleManagedKeysRequest.ReadOnly =
    new Wrapper(impl)
}
