package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetRuleRequest(ruleId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRuleRequest = {
    import GetRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetRuleRequest.ReadOnly =
    zio.aws.waf.model.GetRuleRequest.wrap(buildAwsValue())
}
object GetRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetRuleRequest =
      zio.aws.waf.model.GetRuleRequest(ruleId)
    def ruleId: ResourceId
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRuleRequest
  ) extends zio.aws.waf.model.GetRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRuleRequest
  ): zio.aws.waf.model.GetRuleRequest.ReadOnly = new Wrapper(impl)
}
