package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetXssMatchSetRequest(xssMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest = {
    import GetXssMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetXssMatchSetRequest.ReadOnly =
    zio.aws.waf.model.GetXssMatchSetRequest.wrap(buildAwsValue())
}
object GetXssMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetXssMatchSetRequest =
      zio.aws.waf.model.GetXssMatchSetRequest(xssMatchSetId)
    def xssMatchSetId: ResourceId
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
  ) extends zio.aws.waf.model.GetXssMatchSetRequest.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.xssMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
  ): zio.aws.waf.model.GetXssMatchSetRequest.ReadOnly = new Wrapper(impl)
}
