package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class IPSet(
    ipSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    ipSetDescriptors: Iterable[zio.aws.waf.model.IPSetDescriptor]
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.IPSet = {
    import IPSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.IPSet
      .builder()
      .ipSetId(ResourceId.unwrap(ipSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .ipSetDescriptors(ipSetDescriptors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.IPSet.ReadOnly =
    zio.aws.waf.model.IPSet.wrap(buildAwsValue())
}
object IPSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.IPSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.IPSet = zio.aws.waf.model.IPSet(
      ipSetId,
      name.map(value => value),
      ipSetDescriptors.map { item =>
        item.asEditable
      }
    )
    def ipSetId: ResourceId
    def name: Optional[ResourceName]
    def ipSetDescriptors: List[zio.aws.waf.model.IPSetDescriptor.ReadOnly]
    def getIpSetId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getIpSetDescriptors
        : ZIO[Any, Nothing, List[zio.aws.waf.model.IPSetDescriptor.ReadOnly]] =
      ZIO.succeed(ipSetDescriptors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.IPSet
  ) extends zio.aws.waf.model.IPSet.ReadOnly {
    override val ipSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ipSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val ipSetDescriptors
        : List[zio.aws.waf.model.IPSetDescriptor.ReadOnly] = impl
      .ipSetDescriptors()
      .asScala
      .map { item =>
        zio.aws.waf.model.IPSetDescriptor.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.IPSet
  ): zio.aws.waf.model.IPSet.ReadOnly = new Wrapper(impl)
}
