package zio.aws.waf.model
import zio.aws.waf.model.primitives.{PaginationLimit, NextMarker, ResourceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListActivatedRulesInRuleGroupRequest(
    ruleGroupId: Optional[ResourceId] = Optional.Absent,
    nextMarker: Optional[NextMarker] = Optional.Absent,
    limit: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest = {
    import ListActivatedRulesInRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
      .builder()
      .optionallyWith(
        ruleGroupId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.ruleGroupId)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.waf.model.ListActivatedRulesInRuleGroupRequest.ReadOnly =
    zio.aws.waf.model.ListActivatedRulesInRuleGroupRequest.wrap(buildAwsValue())
}
object ListActivatedRulesInRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListActivatedRulesInRuleGroupRequest =
      zio.aws.waf.model.ListActivatedRulesInRuleGroupRequest(
        ruleGroupId.map(value => value),
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def ruleGroupId: Optional[ResourceId]
    def nextMarker: Optional[NextMarker]
    def limit: Optional[PaginationLimit]
    def getRuleGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("ruleGroupId", ruleGroupId)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
  ) extends zio.aws.waf.model.ListActivatedRulesInRuleGroupRequest.ReadOnly {
    override val ruleGroupId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupId())
      .map(value => zio.aws.waf.model.primitives.ResourceId(value))
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val limit: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.waf.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupRequest
  ): zio.aws.waf.model.ListActivatedRulesInRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
