package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.NextMarker
import scala.jdk.CollectionConverters._
final case class ListGeoMatchSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    geoMatchSets: Optional[Iterable[zio.aws.waf.model.GeoMatchSetSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse = {
    import ListGeoMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        geoMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.geoMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListGeoMatchSetsResponse.ReadOnly =
    zio.aws.waf.model.ListGeoMatchSetsResponse.wrap(buildAwsValue())
}
object ListGeoMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListGeoMatchSetsResponse =
      zio.aws.waf.model.ListGeoMatchSetsResponse(
        nextMarker.map(value => value),
        geoMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def geoMatchSets
        : Optional[List[zio.aws.waf.model.GeoMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getGeoMatchSets: ZIO[Any, AwsError, List[
      zio.aws.waf.model.GeoMatchSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("geoMatchSets", geoMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
  ) extends zio.aws.waf.model.ListGeoMatchSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val geoMatchSets
        : Optional[List[zio.aws.waf.model.GeoMatchSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoMatchSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.GeoMatchSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
  ): zio.aws.waf.model.ListGeoMatchSetsResponse.ReadOnly = new Wrapper(impl)
}
