package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class LoggingConfiguration(
    resourceArn: ResourceArn,
    logDestinationConfigs: Iterable[ResourceArn],
    redactedFields: Optional[Iterable[zio.aws.waf.model.FieldToMatch]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.LoggingConfiguration
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .logDestinationConfigs(logDestinationConfigs.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        redactedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.redactedFields)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.LoggingConfiguration.ReadOnly =
    zio.aws.waf.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.LoggingConfiguration =
      zio.aws.waf.model.LoggingConfiguration(
        resourceArn,
        logDestinationConfigs,
        redactedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: ResourceArn
    def logDestinationConfigs: List[ResourceArn]
    def redactedFields: Optional[List[zio.aws.waf.model.FieldToMatch.ReadOnly]]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getLogDestinationConfigs: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(logDestinationConfigs)
    def getRedactedFields
        : ZIO[Any, AwsError, List[zio.aws.waf.model.FieldToMatch.ReadOnly]] =
      AwsError.unwrapOptionField("redactedFields", redactedFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.LoggingConfiguration
  ) extends zio.aws.waf.model.LoggingConfiguration.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.waf.model.primitives.ResourceArn(impl.resourceArn())
    override val logDestinationConfigs: List[ResourceArn] = impl
      .logDestinationConfigs()
      .asScala
      .map { item =>
        zio.aws.waf.model.primitives.ResourceArn(item)
      }
      .toList
    override val redactedFields
        : Optional[List[zio.aws.waf.model.FieldToMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redactedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.FieldToMatch.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.LoggingConfiguration
  ): zio.aws.waf.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
