package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutLoggingConfigurationRequest(
    loggingConfiguration: zio.aws.waf.model.LoggingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.PutLoggingConfigurationRequest = {
    import PutLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.PutLoggingConfigurationRequest
      .builder()
      .loggingConfiguration(loggingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.PutLoggingConfigurationRequest.ReadOnly =
    zio.aws.waf.model.PutLoggingConfigurationRequest.wrap(buildAwsValue())
}
object PutLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.PutLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.PutLoggingConfigurationRequest =
      zio.aws.waf.model
        .PutLoggingConfigurationRequest(loggingConfiguration.asEditable)
    def loggingConfiguration: zio.aws.waf.model.LoggingConfiguration.ReadOnly
    def getLoggingConfiguration
        : ZIO[Any, Nothing, zio.aws.waf.model.LoggingConfiguration.ReadOnly] =
      ZIO.succeed(loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.PutLoggingConfigurationRequest
  ) extends zio.aws.waf.model.PutLoggingConfigurationRequest.ReadOnly {
    override val loggingConfiguration
        : zio.aws.waf.model.LoggingConfiguration.ReadOnly =
      zio.aws.waf.model.LoggingConfiguration.wrap(impl.loggingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.PutLoggingConfigurationRequest
  ): zio.aws.waf.model.PutLoggingConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
