package zio.aws.waf.model
import scala.jdk.CollectionConverters._
sealed trait RateKey {
  def unwrap: software.amazon.awssdk.services.waf.model.RateKey
}
object RateKey {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.RateKey
  ): zio.aws.waf.model.RateKey = value match {
    case software.amazon.awssdk.services.waf.model.RateKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.RateKey.IP =>
      val r = IP
      r
  }
  case object unknownToSdkVersion extends zio.aws.waf.model.RateKey {
    override def unwrap: software.amazon.awssdk.services.waf.model.RateKey =
      software.amazon.awssdk.services.waf.model.RateKey.UNKNOWN_TO_SDK_VERSION
  }
  case object IP extends zio.aws.waf.model.RateKey {
    override def unwrap: software.amazon.awssdk.services.waf.model.RateKey =
      software.amazon.awssdk.services.waf.model.RateKey.IP
  }
}
