package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class RegexMatchSet(
    regexMatchSetId: Optional[ResourceId] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    regexMatchTuples: Optional[Iterable[zio.aws.waf.model.RegexMatchTuple]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchSet = {
    import RegexMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchSet
      .builder()
      .optionallyWith(
        regexMatchSetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.regexMatchSetId)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        regexMatchTuples.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexMatchTuples)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexMatchSet.ReadOnly =
    zio.aws.waf.model.RegexMatchSet.wrap(buildAwsValue())
}
object RegexMatchSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RegexMatchSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexMatchSet =
      zio.aws.waf.model.RegexMatchSet(
        regexMatchSetId.map(value => value),
        name.map(value => value),
        regexMatchTuples.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def regexMatchSetId: Optional[ResourceId]
    def name: Optional[ResourceName]
    def regexMatchTuples
        : Optional[List[zio.aws.waf.model.RegexMatchTuple.ReadOnly]]
    def getRegexMatchSetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("regexMatchSetId", regexMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getRegexMatchTuples
        : ZIO[Any, AwsError, List[zio.aws.waf.model.RegexMatchTuple.ReadOnly]] =
      AwsError.unwrapOptionField("regexMatchTuples", regexMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSet
  ) extends zio.aws.waf.model.RegexMatchSet.ReadOnly {
    override val regexMatchSetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.regexMatchSetId())
      .map(value => zio.aws.waf.model.primitives.ResourceId(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val regexMatchTuples
        : Optional[List[zio.aws.waf.model.RegexMatchTuple.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexMatchTuples())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.waf.model.RegexMatchTuple.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSet
  ): zio.aws.waf.model.RegexMatchSet.ReadOnly = new Wrapper(impl)
}
