package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class RegexMatchSetSummary(
    regexMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchSetSummary = {
    import RegexMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
      .builder()
      .regexMatchSetId(ResourceId.unwrap(regexMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexMatchSetSummary.ReadOnly =
    zio.aws.waf.model.RegexMatchSetSummary.wrap(buildAwsValue())
}
object RegexMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexMatchSetSummary =
      zio.aws.waf.model.RegexMatchSetSummary(regexMatchSetId, name)
    def regexMatchSetId: ResourceId
    def name: ResourceName
    def getRegexMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
  ) extends zio.aws.waf.model.RegexMatchSetSummary.ReadOnly {
    override val regexMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexMatchSetId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
  ): zio.aws.waf.model.RegexMatchSetSummary.ReadOnly = new Wrapper(impl)
}
