package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RuleUpdate(
    action: zio.aws.waf.model.ChangeAction,
    predicate: zio.aws.waf.model.Predicate
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.RuleUpdate = {
    import RuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RuleUpdate
      .builder()
      .action(action.unwrap)
      .predicate(predicate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RuleUpdate.ReadOnly =
    zio.aws.waf.model.RuleUpdate.wrap(buildAwsValue())
}
object RuleUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RuleUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RuleUpdate =
      zio.aws.waf.model.RuleUpdate(action, predicate.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def predicate: zio.aws.waf.model.Predicate.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getPredicate: ZIO[Any, Nothing, zio.aws.waf.model.Predicate.ReadOnly] =
      ZIO.succeed(predicate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RuleUpdate
  ) extends zio.aws.waf.model.RuleUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val predicate: zio.aws.waf.model.Predicate.ReadOnly =
      zio.aws.waf.model.Predicate.wrap(impl.predicate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RuleUpdate
  ): zio.aws.waf.model.RuleUpdate.ReadOnly = new Wrapper(impl)
}
