package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class SizeConstraintSet(
    sizeConstraintSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    sizeConstraints: Iterable[zio.aws.waf.model.SizeConstraint]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraintSet = {
    import SizeConstraintSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraintSet
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .sizeConstraints(sizeConstraints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SizeConstraintSet.ReadOnly =
    zio.aws.waf.model.SizeConstraintSet.wrap(buildAwsValue())
}
object SizeConstraintSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraintSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SizeConstraintSet =
      zio.aws.waf.model.SizeConstraintSet(
        sizeConstraintSetId,
        name.map(value => value),
        sizeConstraints.map { item =>
          item.asEditable
        }
      )
    def sizeConstraintSetId: ResourceId
    def name: Optional[ResourceName]
    def sizeConstraints: List[zio.aws.waf.model.SizeConstraint.ReadOnly]
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getSizeConstraints
        : ZIO[Any, Nothing, List[zio.aws.waf.model.SizeConstraint.ReadOnly]] =
      ZIO.succeed(sizeConstraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSet
  ) extends zio.aws.waf.model.SizeConstraintSet.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sizeConstraintSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val sizeConstraints
        : List[zio.aws.waf.model.SizeConstraint.ReadOnly] = impl
      .sizeConstraints()
      .asScala
      .map { item =>
        zio.aws.waf.model.SizeConstraint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSet
  ): zio.aws.waf.model.SizeConstraintSet.ReadOnly = new Wrapper(impl)
}
