package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SqlInjectionMatchSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    sqlInjectionMatchTuple: zio.aws.waf.model.SqlInjectionMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate = {
    import SqlInjectionMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .sqlInjectionMatchTuple(sqlInjectionMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SqlInjectionMatchSetUpdate.ReadOnly =
    zio.aws.waf.model.SqlInjectionMatchSetUpdate.wrap(buildAwsValue())
}
object SqlInjectionMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SqlInjectionMatchSetUpdate =
      zio.aws.waf.model
        .SqlInjectionMatchSetUpdate(action, sqlInjectionMatchTuple.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def sqlInjectionMatchTuple
        : zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getSqlInjectionMatchTuple
        : ZIO[Any, Nothing, zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly] =
      ZIO.succeed(sqlInjectionMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate
  ) extends zio.aws.waf.model.SqlInjectionMatchSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val sqlInjectionMatchTuple
        : zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly =
      zio.aws.waf.model.SqlInjectionMatchTuple
        .wrap(impl.sqlInjectionMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate
  ): zio.aws.waf.model.SqlInjectionMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
