package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{MetricName, ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class SubscribedRuleGroupSummary(
    ruleGroupId: ResourceId,
    name: ResourceName,
    metricName: MetricName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary = {
    import SubscribedRuleGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SubscribedRuleGroupSummary.ReadOnly =
    zio.aws.waf.model.SubscribedRuleGroupSummary.wrap(buildAwsValue())
}
object SubscribedRuleGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SubscribedRuleGroupSummary =
      zio.aws.waf.model
        .SubscribedRuleGroupSummary(ruleGroupId, name, metricName)
    def ruleGroupId: ResourceId
    def name: ResourceName
    def metricName: MetricName
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary
  ) extends zio.aws.waf.model.SubscribedRuleGroupSummary.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleGroupId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
    override val metricName: MetricName =
      zio.aws.waf.model.primitives.MetricName(impl.metricName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SubscribedRuleGroupSummary
  ): zio.aws.waf.model.SubscribedRuleGroupSummary.ReadOnly = new Wrapper(impl)
}
