package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateByteMatchSetRequest(
    byteMatchSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.waf.model.ByteMatchSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateByteMatchSetRequest = {
    import UpdateByteMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateByteMatchSetRequest
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateByteMatchSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateByteMatchSetRequest.wrap(buildAwsValue())
}
object UpdateByteMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateByteMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateByteMatchSetRequest =
      zio.aws.waf.model.UpdateByteMatchSetRequest(
        byteMatchSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def byteMatchSetId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.waf.model.ByteMatchSetUpdate.ReadOnly]
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.waf.model.ByteMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateByteMatchSetRequest
  ) extends zio.aws.waf.model.UpdateByteMatchSetRequest.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.byteMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates: List[zio.aws.waf.model.ByteMatchSetUpdate.ReadOnly] =
      impl
        .updates()
        .asScala
        .map { item =>
          zio.aws.waf.model.ByteMatchSetUpdate.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateByteMatchSetRequest
  ): zio.aws.waf.model.UpdateByteMatchSetRequest.ReadOnly = new Wrapper(impl)
}
