package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateSizeConstraintSetRequest(
    sizeConstraintSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.waf.model.SizeConstraintSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetRequest = {
    import UpdateSizeConstraintSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetRequest
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateSizeConstraintSetRequest.ReadOnly =
    zio.aws.waf.model.UpdateSizeConstraintSetRequest.wrap(buildAwsValue())
}
object UpdateSizeConstraintSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateSizeConstraintSetRequest =
      zio.aws.waf.model.UpdateSizeConstraintSetRequest(
        sizeConstraintSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def sizeConstraintSetId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.waf.model.SizeConstraintSetUpdate.ReadOnly]
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.waf.model.SizeConstraintSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetRequest
  ) extends zio.aws.waf.model.UpdateSizeConstraintSetRequest.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sizeConstraintSetId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates
        : List[zio.aws.waf.model.SizeConstraintSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.waf.model.SizeConstraintSetUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateSizeConstraintSetRequest
  ): zio.aws.waf.model.UpdateSizeConstraintSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
