package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WebACLUpdate(
    action: zio.aws.waf.model.ChangeAction,
    activatedRule: zio.aws.waf.model.ActivatedRule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.WebACLUpdate = {
    import WebACLUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.WebACLUpdate
      .builder()
      .action(action.unwrap)
      .activatedRule(activatedRule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.waf.model.WebACLUpdate.ReadOnly =
    zio.aws.waf.model.WebACLUpdate.wrap(buildAwsValue())
}
object WebACLUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.WebACLUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.WebACLUpdate =
      zio.aws.waf.model.WebACLUpdate(action, activatedRule.asEditable)
    def action: zio.aws.waf.model.ChangeAction
    def activatedRule: zio.aws.waf.model.ActivatedRule.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getActivatedRule
        : ZIO[Any, Nothing, zio.aws.waf.model.ActivatedRule.ReadOnly] =
      ZIO.succeed(activatedRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.WebACLUpdate
  ) extends zio.aws.waf.model.WebACLUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val activatedRule: zio.aws.waf.model.ActivatedRule.ReadOnly =
      zio.aws.waf.model.ActivatedRule.wrap(impl.activatedRule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.WebACLUpdate
  ): zio.aws.waf.model.WebACLUpdate.ReadOnly = new Wrapper(impl)
}
