package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class XssMatchSetSummary(
    xssMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.XssMatchSetSummary = {
    import XssMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchSetSummary
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.XssMatchSetSummary.ReadOnly =
    zio.aws.waf.model.XssMatchSetSummary.wrap(buildAwsValue())
}
object XssMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.XssMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.XssMatchSetSummary =
      zio.aws.waf.model.XssMatchSetSummary(xssMatchSetId, name)
    def xssMatchSetId: ResourceId
    def name: ResourceName
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetSummary
  ) extends zio.aws.waf.model.XssMatchSetSummary.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.xssMatchSetId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetSummary
  ): zio.aws.waf.model.XssMatchSetSummary.ReadOnly = new Wrapper(impl)
}
