package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class ByteMatchSet(
    byteMatchSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    byteMatchTuples: Iterable[zio.aws.waf.model.ByteMatchTuple]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchSet = {
    import ByteMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchSet
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .byteMatchTuples(byteMatchTuples.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ByteMatchSet.ReadOnly =
    zio.aws.waf.model.ByteMatchSet.wrap(buildAwsValue())
}
object ByteMatchSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.ByteMatchSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ByteMatchSet =
      zio.aws.waf.model.ByteMatchSet(
        byteMatchSetId,
        name.map(value => value),
        byteMatchTuples.map { item =>
          item.asEditable
        }
      )
    def byteMatchSetId: ResourceId
    def name: Optional[ResourceName]
    def byteMatchTuples: List[zio.aws.waf.model.ByteMatchTuple.ReadOnly]
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getByteMatchTuples
        : ZIO[Any, Nothing, List[zio.aws.waf.model.ByteMatchTuple.ReadOnly]] =
      ZIO.succeed(byteMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSet
  ) extends zio.aws.waf.model.ByteMatchSet.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.byteMatchSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val byteMatchTuples
        : List[zio.aws.waf.model.ByteMatchTuple.ReadOnly] = impl
      .byteMatchTuples()
      .asScala
      .map { item =>
        zio.aws.waf.model.ByteMatchTuple.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSet
  ): zio.aws.waf.model.ByteMatchSet.ReadOnly = new Wrapper(impl)
}
