package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateByteMatchSetRequest(
    name: ResourceName,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateByteMatchSetRequest = {
    import CreateByteMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateByteMatchSetRequest.ReadOnly =
    zio.aws.waf.model.CreateByteMatchSetRequest.wrap(buildAwsValue())
}
object CreateByteMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateByteMatchSetRequest =
      zio.aws.waf.model.CreateByteMatchSetRequest(name, changeToken)
    def name: ResourceName
    def changeToken: ChangeToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetRequest
  ) extends zio.aws.waf.model.CreateByteMatchSetRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetRequest
  ): zio.aws.waf.model.CreateByteMatchSetRequest.ReadOnly = new Wrapper(impl)
}
