package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateByteMatchSetResponse(
    byteMatchSet: Optional[zio.aws.waf.model.ByteMatchSet] = Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse = {
    import CreateByteMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
      .builder()
      .optionallyWith(byteMatchSet.map(value => value.buildAwsValue()))(
        _.byteMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateByteMatchSetResponse.ReadOnly =
    zio.aws.waf.model.CreateByteMatchSetResponse.wrap(buildAwsValue())
}
object CreateByteMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateByteMatchSetResponse =
      zio.aws.waf.model.CreateByteMatchSetResponse(
        byteMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def byteMatchSet: Optional[zio.aws.waf.model.ByteMatchSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getByteMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.ByteMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("byteMatchSet", byteMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ) extends zio.aws.waf.model.CreateByteMatchSetResponse.ReadOnly {
    override val byteMatchSet
        : Optional[zio.aws.waf.model.ByteMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byteMatchSet())
        .map(value => zio.aws.waf.model.ByteMatchSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ): zio.aws.waf.model.CreateByteMatchSetResponse.ReadOnly = new Wrapper(impl)
}
