package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class CreateRegexPatternSetResponse(
    regexPatternSet: Optional[zio.aws.waf.model.RegexPatternSet] =
      Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse = {
    import CreateRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
      .builder()
      .optionallyWith(regexPatternSet.map(value => value.buildAwsValue()))(
        _.regexPatternSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.CreateRegexPatternSetResponse.ReadOnly =
    zio.aws.waf.model.CreateRegexPatternSetResponse.wrap(buildAwsValue())
}
object CreateRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.CreateRegexPatternSetResponse =
      zio.aws.waf.model.CreateRegexPatternSetResponse(
        regexPatternSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def regexPatternSet: Optional[zio.aws.waf.model.RegexPatternSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getRegexPatternSet
        : ZIO[Any, AwsError, zio.aws.waf.model.RegexPatternSet.ReadOnly] =
      AwsError.unwrapOptionField("regexPatternSet", regexPatternSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
  ) extends zio.aws.waf.model.CreateRegexPatternSetResponse.ReadOnly {
    override val regexPatternSet
        : Optional[zio.aws.waf.model.RegexPatternSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regexPatternSet())
        .map(value => zio.aws.waf.model.RegexPatternSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
  ): zio.aws.waf.model.CreateRegexPatternSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
