package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class DeleteWebAclRequest(
    webACLId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteWebAclRequest = {
    import DeleteWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteWebAclRequest
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteWebAclRequest.ReadOnly =
    zio.aws.waf.model.DeleteWebAclRequest.wrap(buildAwsValue())
}
object DeleteWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteWebAclRequest =
      zio.aws.waf.model.DeleteWebAclRequest(webACLId, changeToken)
    def webACLId: ResourceId
    def changeToken: ChangeToken
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteWebAclRequest
  ) extends zio.aws.waf.model.DeleteWebAclRequest.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.webACLId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteWebAclRequest
  ): zio.aws.waf.model.DeleteWebAclRequest.ReadOnly = new Wrapper(impl)
}
