package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.ChangeToken
import scala.jdk.CollectionConverters._
final case class DeleteWebAclResponse(
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteWebAclResponse = {
    import DeleteWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.DeleteWebAclResponse.ReadOnly =
    zio.aws.waf.model.DeleteWebAclResponse.wrap(buildAwsValue())
}
object DeleteWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.DeleteWebAclResponse =
      zio.aws.waf.model.DeleteWebAclResponse(changeToken.map(value => value))
    def changeToken: Optional[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
  ) extends zio.aws.waf.model.DeleteWebAclResponse.ReadOnly {
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.waf.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
  ): zio.aws.waf.model.DeleteWebAclResponse.ReadOnly = new Wrapper(impl)
}
