package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class GeoMatchSet(
    geoMatchSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    geoMatchConstraints: Iterable[zio.aws.waf.model.GeoMatchConstraint]
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.GeoMatchSet = {
    import GeoMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GeoMatchSet
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .geoMatchConstraints(geoMatchConstraints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GeoMatchSet.ReadOnly =
    zio.aws.waf.model.GeoMatchSet.wrap(buildAwsValue())
}
object GeoMatchSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.GeoMatchSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GeoMatchSet =
      zio.aws.waf.model.GeoMatchSet(
        geoMatchSetId,
        name.map(value => value),
        geoMatchConstraints.map { item =>
          item.asEditable
        }
      )
    def geoMatchSetId: ResourceId
    def name: Optional[ResourceName]
    def geoMatchConstraints: List[zio.aws.waf.model.GeoMatchConstraint.ReadOnly]
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getGeoMatchConstraints: ZIO[Any, Nothing, List[
      zio.aws.waf.model.GeoMatchConstraint.ReadOnly
    ]] = ZIO.succeed(geoMatchConstraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSet
  ) extends zio.aws.waf.model.GeoMatchSet.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.geoMatchSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val geoMatchConstraints
        : List[zio.aws.waf.model.GeoMatchConstraint.ReadOnly] = impl
      .geoMatchConstraints()
      .asScala
      .map { item =>
        zio.aws.waf.model.GeoMatchConstraint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSet
  ): zio.aws.waf.model.GeoMatchSet.ReadOnly = new Wrapper(impl)
}
