package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceName, ResourceId}
import scala.jdk.CollectionConverters._
final case class GeoMatchSetSummary(
    geoMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GeoMatchSetSummary = {
    import GeoMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GeoMatchSetSummary.ReadOnly =
    zio.aws.waf.model.GeoMatchSetSummary.wrap(buildAwsValue())
}
object GeoMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GeoMatchSetSummary =
      zio.aws.waf.model.GeoMatchSetSummary(geoMatchSetId, name)
    def geoMatchSetId: ResourceId
    def name: ResourceName
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
  ) extends zio.aws.waf.model.GeoMatchSetSummary.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.geoMatchSetId())
    override val name: ResourceName =
      zio.aws.waf.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetSummary
  ): zio.aws.waf.model.GeoMatchSetSummary.ReadOnly = new Wrapper(impl)
}
