package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIpSetResponse(
    ipSet: Optional[zio.aws.waf.model.IPSet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetIpSetResponse = {
    import GetIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetIpSetResponse
      .builder()
      .optionallyWith(ipSet.map(value => value.buildAwsValue()))(_.ipSet)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetIpSetResponse.ReadOnly =
    zio.aws.waf.model.GetIpSetResponse.wrap(buildAwsValue())
}
object GetIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetIpSetResponse =
      zio.aws.waf.model.GetIpSetResponse(ipSet.map(value => value.asEditable))
    def ipSet: Optional[zio.aws.waf.model.IPSet.ReadOnly]
    def getIpSet: ZIO[Any, AwsError, zio.aws.waf.model.IPSet.ReadOnly] =
      AwsError.unwrapOptionField("ipSet", ipSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetIpSetResponse
  ) extends zio.aws.waf.model.GetIpSetResponse.ReadOnly {
    override val ipSet: Optional[zio.aws.waf.model.IPSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSet())
        .map(value => zio.aws.waf.model.IPSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetIpSetResponse
  ): zio.aws.waf.model.GetIpSetResponse.ReadOnly = new Wrapper(impl)
}
