package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetSizeConstraintSetRequest(sizeConstraintSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest = {
    import GetSizeConstraintSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetSizeConstraintSetRequest.ReadOnly =
    zio.aws.waf.model.GetSizeConstraintSetRequest.wrap(buildAwsValue())
}
object GetSizeConstraintSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetSizeConstraintSetRequest =
      zio.aws.waf.model.GetSizeConstraintSetRequest(sizeConstraintSetId)
    def sizeConstraintSetId: ResourceId
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
  ) extends zio.aws.waf.model.GetSizeConstraintSetRequest.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.sizeConstraintSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
  ): zio.aws.waf.model.GetSizeConstraintSetRequest.ReadOnly = new Wrapper(impl)
}
