package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSqlInjectionMatchSetResponse(
    sqlInjectionMatchSet: Optional[zio.aws.waf.model.SqlInjectionMatchSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse = {
    import GetSqlInjectionMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
      .builder()
      .optionallyWith(sqlInjectionMatchSet.map(value => value.buildAwsValue()))(
        _.sqlInjectionMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.GetSqlInjectionMatchSetResponse.ReadOnly =
    zio.aws.waf.model.GetSqlInjectionMatchSetResponse.wrap(buildAwsValue())
}
object GetSqlInjectionMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.GetSqlInjectionMatchSetResponse =
      zio.aws.waf.model.GetSqlInjectionMatchSetResponse(
        sqlInjectionMatchSet.map(value => value.asEditable)
      )
    def sqlInjectionMatchSet
        : Optional[zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly]
    def getSqlInjectionMatchSet
        : ZIO[Any, AwsError, zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("sqlInjectionMatchSet", sqlInjectionMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
  ) extends zio.aws.waf.model.GetSqlInjectionMatchSetResponse.ReadOnly {
    override val sqlInjectionMatchSet
        : Optional[zio.aws.waf.model.SqlInjectionMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqlInjectionMatchSet())
        .map(value => zio.aws.waf.model.SqlInjectionMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
  ): zio.aws.waf.model.GetSqlInjectionMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
