package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{HeaderValue, HeaderName}
import scala.jdk.CollectionConverters._
final case class HTTPHeader(
    name: Optional[HeaderName] = Optional.Absent,
    value: Optional[HeaderValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.HTTPHeader = {
    import HTTPHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.HTTPHeader
      .builder()
      .optionallyWith(
        name.map(value => HeaderName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => HeaderValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.HTTPHeader.ReadOnly =
    zio.aws.waf.model.HTTPHeader.wrap(buildAwsValue())
}
object HTTPHeader {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.HTTPHeader] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.HTTPHeader = zio.aws.waf.model
      .HTTPHeader(name.map(value => value), value.map(value => value))
    def name: Optional[HeaderName]
    def value: Optional[HeaderValue]
    def getName: ZIO[Any, AwsError, HeaderName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, HeaderValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.HTTPHeader
  ) extends zio.aws.waf.model.HTTPHeader.ReadOnly {
    override val name: Optional[HeaderName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.HeaderName(value))
    override val value: Optional[HeaderValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.waf.model.primitives.HeaderValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.HTTPHeader
  ): zio.aws.waf.model.HTTPHeader.ReadOnly = new Wrapper(impl)
}
